<?php
header("Content-Type: application/json");

require "../db.php";
require "utils.php";
require "rate_limit.php";

$config = require "../config.php";

blockCheck($db, $config);

// التحقق من التوكن
$token = $_SERVER['HTTP_X_API_SECRET'] ?? '';
if ($token !== $config['api_secret']) {
    http_response_code(403);
    echo json_encode(["error"=>"ACCESS_DENIED"]);
    exit;
}

$data = json_decode(file_get_contents("php://input"), true);

$step = $data['step'] ?? null;

// معالجة كل خطوة
switch ($step) {

    case 2: // فحص الهوية
        $id = $data['id'] ?? '';
        if (!preg_match("/^\d{9}$/",$id)) {
            rateLimit($db,$config,false);
            echo json_encode(["error"=>"INVALID_ID"]);
            exit;
        }

        // فحص الخوارزمية
        if (!isValidIsraeliID($id)) {
            rateLimit($db,$config,false);
            echo json_encode(["error"=>"INVALID_ID"]);
            exit;
        }

        rateLimit($db,$config,true);
        echo json_encode(["ok"=>true]);
        break;

    case 3: // فحص الاسم
        if (!preg_match('/^[\x{0590}-\x{05FF}]+$/u',$data['first_name']) ||
            !preg_match('/^[\x{0590}-\x{05FF}]+$/u',$data['last_name'])) {
            rateLimit($db,$config,false);
            echo json_encode(["error"=>"NAME_INVALID"]);
            exit;
        }

        rateLimit($db,$config,true);
        echo json_encode(["ok"=>true]);
        break;

    case 4: // إصدار الهوية
        if (empty($data['issue_date'])) {
            rateLimit($db,$config,false);
            echo json_encode(["error"=>"ISSUE_DATE_MISSING"]);
            exit;
        }

        rateLimit($db,$config,true);
        echo json_encode(["ok"=>true]);
        break;

    default:
        echo json_encode(["error"=>"UNKNOWN_STEP"]);
}

function isValidIsraeliID($id){
    $sum = 0;
    for($i=0;$i<9;$i++){
        $d = (int)$id[$i] * (($i%2)+1);
        if($d>9) $d -= 9;
        $sum += $d;
    }
    return $sum % 10 === 0;
}
